<?php

/**
*
* @package Free Tube Script
* @version v1.0
* @copyright (c) 2011 Agriz
* @license GNU Public License Under Certain Conditions [Powered by should remain unchanged]
* @contact http://www.agrizlive.com
*
*/

	class User extends AppModel {
		var $name = 'User';
		var $hasMany = array('Video','Comment');		
		
		var $validate = array(
			'username' => array(
				'notEmpty' => array(
					'rule' => 'notEmpty',
					'required' => true,
					'allowEmpty' => false,
					'message' => 'Name should not be empty'
				)		
			),
			'password2' => array(
				'notEmpty' => array(
					'rule' => "notEmpty",
					'required' => true,
					'allowEmpty' => false,
					'message' => 'Enter some password'
				),
				'notEmpty' => array(
					'rule' => array('minLength', 5),
					'required' => true,
					'message' => 'Password length should be 5 characters long'
				),
				'passwordSimilar' => array(
					'rule' => 'checkPasswords',
					'message' => 'Different passwords entered'
				)	
			),
			'email' => array(
				'notEmpty' => array(
					'rule' => 'email',
					'required' => true,
					'allowEmpty' => false,
					'message' => 'Enter a valid email address'
				),
				'unique' => array(
					'rule' => array('checkUnique', 'email'),
					'message' => 'Email already exist.'
				)	
			)
		);
		
		function checkUnique($data, $fieldName) {
			$valid = false;
			if(isset($fieldName) && $this->hasField($fieldName)) {
				$valid = $this->isUnique(array($fieldName => $data));
			}
			return $valid;
		}
		
		function checkPasswords($data) {
			if($this->data['User']['password'] == $this->data['User']['password2hashed']) {
				return true;
			}	
			return false;
		}
		
		function checkPasswordsnew($data) {
			if($data['password'] == $this->data['User']['password']) {
				return true;
			}	
			return false;
		}
		
		function changeValidation($type)
		{
			if($type == 'email') {
				$this->validate = array (
					'email' => array(
						'notEmpty' => array(
							'rule' => 'email',
							'required' => true,
							'allowEmpty' => false,
							'message' => 'Enter a valid email.'
						),
						'unique' => array(
							'rule' => array('checkUnique', 'email'),
							'message' => 'Email already exist'
						)	
					)
				);
			}
			if($type == 'password')	{
				$this->validate = array (
					'password' => array(
						'notEmpty' => array(
							'rule' => 'notEmpty',
							'required' => true,
							'allowEmpty' => false,
							'message' => 'Enter some password'
						),
						'passwordSimilar' => array(
							'rule' => 'checkPasswordsnew',
							'message' => 'Different passwords entered'
						),
						'minLength'	 => array(
							'rule' => array('minLength', 5),
							'requried' => true,
							'message' => 'Password length should be 5 characters long'
						)	
					)	
				);	
			}
			else {
				$this->validate = array();
			}
		}
		
	}
?>
